% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmstat.ui.elem.R
\name{mmstat.ui.elem}
\alias{mmstat.ui.elem}
\title{mmstat.ui.elem}
\usage{
mmstat.ui.elem(inputId, type, ...)
}
\arguments{
\item{inputId}{character: input slot that will be used to access the value}

\item{type}{character: element type}

\item{...}{further named parameter to Shiny UI elements}
}
\value{
nothing
}
\description{
Adds a new UI element to the app interface. The following types from Shiny are allowed:
\itemize{
\item \code{\link[shiny:actionButton]{actionButton}},
\item \code{\link[shiny:checkboxInput]{checkboxInput}},
\item \code{\link[shiny:checkboxGroupInput]{checkboxGroupInput}},
\item \code{\link[shiny:dateInput]{dateInput}},
\item \code{\link[shiny:dateRangeInput]{dateRangeInput}},
\item \code{\link[shiny:fileInput]{fileInput}},
\item \code{\link[shiny:helpText]{helpText}},
\item \code{\link[shiny:numericInput]{numericInput}},
\item \code{\link[shiny:radioButtons]{radioButtons}},
\item \code{\link[shiny:selectInput]{selectInput}},
\item \code{\link[shiny:sliderInput]{sliderInput}},
\item \code{\link[shiny:submitButton]{submitButton}}, and
\item \code{\link[shiny:textInput]{textInput}}.
}

Additionally some standard statistical UI elements are supported (links go to the Shiny element used):
\itemize{
\item \code{\link[shiny:sliderInput]{sampleSize}},
\item \code{\link[shiny:actionButton]{drawSample}},
\item \code{\link[shiny:sliderInput]{speedSlider}},
\item \code{\link[shiny:sliderInput]{confidenceLevel}},
\item \code{\link[shiny:sliderInput]{significance}},
\item \code{\link[shiny:radioButtons]{testHypotheses}},
\item \code{\link[shiny:selectInput]{dataSet}},
\item \code{\link[shiny:selectInput]{variable1}},
\item \code{\link[shiny:selectInput]{variableN}}, and
\item \code{\link[shiny:sliderInput]{fontSize}}.
}

Partially these elements have default settings which can be overwritten.
}
\examples{
mmstat.ui.elem(inputId="alpha", type="significance")
}
