% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html_matrix.R
\name{hm_cell}
\alias{hm_cell}
\alias{hm_index}
\alias{hm_row}
\alias{hm_col}
\alias{hm_title}
\alias{hm_colmargintitle}
\alias{hm_rowmargintitle}
\alias{hm_total}
\alias{hm_table}
\alias{hm_colmargin}
\alias{hm_rowmargin}
\alias{hm_tr}
\title{hm_cell}
\usage{
hm_cell(x, row = NULL, col = NULL, ..., byrow = FALSE)

hm_index(x, ind, ...)

hm_title(x, ...)

hm_colmargintitle(x, ...)

hm_rowmargintitle(x, ...)

hm_total(x, ...)

hm_table(x, ...)

hm_row(x, ind, ...)

hm_col(x, ind, ...)

hm_colmargin(x, ind, ...)

hm_rowmargin(x, ind, ...)

hm_tr(x, ind, ...)
}
\arguments{
\item{x}{html_matrix object}

\item{row}{integer: row(s) to access}

\item{col}{integer: column(s) to access}

\item{...}{elements to change}

\item{byrow}{logical: order indices by row or column (default: \code{FALSE})}

\item{ind}{integer vector or matrix: access various (row and columns) elements (first column: row, second column: column)}
}
\value{
modified html_matrix object
}
\description{
\itemize{
\item \code{hm_cell} or \code{hm_index} modify a data cell format (\code{fmt="\%s"}), value (unnamed parameter) or style (\code{text_align="left"})
\item \code{hm_col} or \code{hm_row} modify a row or column format (\code{fmt="\%s"}), value (unnamed parameter) or style (\code{text_align="left"})
}
}
\examples{
l <- html_matrix(matrix(1:6, ncol=2))
# replace l[1,1] by NA
hm_cell(l, 1, 1, NA)
# replace l[1,1] by NA and set the text_align to center
hm_cell(l, 1, 1, NA, text_align="center")
# replace l[1,3] and l[2,1] by NA
rcind <- cbind(c(1,3), c(2, 1))
hm_index(l, rcind, NA)
# set a new title
hm_title(l, "new title")
# set a new row or column title
hm_row(l, 2, "row 2")
hm_col(l, 1, "col 1")
# set fmt by column or row
print(hm_cell(l, fmt=c("\%.0f", "\%.1f", "\%.2f"), byrow=FALSE), which="fmt")
print(hm_cell(l, fmt=c("\%.0f", "\%.1f"), byrow=TRUE), which="fmt")
}
