% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pymol_script_significant_residue_proc.R
\name{pymol_script_significant_residue_proc}
\alias{pymol_script_significant_residue_proc}
\title{Writes a text files with pymol scripts to list significant residues.}
\usage{
pymol_script_significant_residue_proc(
  input_up,
  input_proc,
  path = "",
  ranges = c(-Inf, seq(-30, 30, by = 10), Inf),
  pv_cutoff = 0.01,
  replicates = 3
)
}
\arguments{
\item{input_up}{Dataframe with organized deuteration uptake. Input generated using output_tp() function.}

\item{input_proc}{Dataframe with organized procent deuteration data. Input generated using output_tp_proc() function.}

\item{path}{location where the Pymol scripts will be saved}

\item{ranges}{ranges for coloring scheme. Default set to c(-Inf, seq(-30, 30, by=10), Inf)}

\item{pv_cutoff}{p-value cutoff here set up to 0.01}

\item{replicates}{number of replicates in sample. Default set to 3.}
}
\value{
pymol script with residues colored based on average of procent deuteration per residue.
}
\description{
Function write a script that can be used in pymol to color structure.
Number of colors and corresponding to them ranges can be defined by user.
Residues are colored by average procent_deuteration from the significant peptides per residues.
}
\examples{
\donttest{
file_nm<-system.file("extdata", "All_results_table.csv", package = "HDXBoxeR")
a_up<- output_tp(file_nm)
a_proc<- output_tp(file_nm, percent=TRUE)
pymol_script_significant_residue_proc(input_proc=a_proc,
input_up=a_up, path=tempdir(), replicates=3, pv_cutoff=0.01,
ranges=c(-Inf,-40, -30,-20,-10, 0,10, 20,30,40, Inf))
}
}
