% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modalityMediationDataGen.R
\name{modalityMediationDataGen}
\alias{modalityMediationDataGen}
\title{Data Generation for High-Dimensional Mediation Model}
\usage{
modalityMediationDataGen(
  n = 100,
  p = 50,
  sigmaY = 1,
  sizeNonZero = c(3, 3, 4),
  alphaMean = c(6, 4, 2),
  alphaSd = 0.1,
  betaMean = c(6, 4, 2),
  betaSd = 0.1,
  sigmaM1 = NULL,
  gamma = 3,
  generateLaplacianMatrix = FALSE,
  seed = 20231201
)
}
\arguments{
\item{n}{The number of subjects for the high-dimensional mediation model)}

\item{p}{The number of high-dimensional mediators.}

\item{sigmaY}{The argument "sigmaY" represents the standard deviation (SD) of the error distribution for the dependent variable.}

\item{sizeNonZero}{The number of nonzero mediators. Here, we provide simulated scenarios that could produce large, medium,
and small mediated effects, generating from a normal distribution.}

\item{alphaMean, alphaSd}{The mean and SD vector of the effect between the mediator and independent variable.}

\item{betaMean, betaSd}{The mean and SD vector of the effect between the mediator and dependent variable.}

\item{sigmaM1}{The covariance matrix of the error distribution among mediators. Default is \code{diag(p)}.}

\item{gamma}{The true value of direct effect.}

\item{generateLaplacianMatrix}{A logical value to specify whether to generate Laplacian matrix for network penalty.}

\item{seed}{The random seed. Default is NULL to use the current seed.}
}
\value{
A object with three elements.
\itemize{
\item MediData: The simulated data for high-dimensional mediation model.
\item MediPara: The true value for mediated effect and direct effect.
\item Info : The output includes random seed, parameter setting, and Laplacian matrix for generating mediation model.
}
}
\description{
Data Generation for High-Dimensional Mediation Model
}
\examples{
simuData <- modalityMediationDataGen(seed = 20231201)
}
