% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_har.r
\name{read_har}
\alias{read_har}
\title{Read a GEMPACK HAR file into R}
\usage{
read_har(
  con,
  useCoefficientsAsNames = FALSE,
  toLowerCase = TRUE,
  headersToRead = NULL
)
}
\arguments{
\item{con}{Connection or path to HAR file}

\item{useCoefficientsAsNames}{If a coefficient name is present in the header, use that instead of the four-letter header}

\item{toLowerCase}{= TRUE Turn all strings to lower case}

\item{headersToRead}{= NULL A vector of header names to read in}
}
\value{
A list of headers
}
\description{
Reads in a GEMPACK HAR file and returns its  representation a list. Currently can only process integer headers, real full headers and character headers
}
\examples{
fl <- system.file("extdata/example1.har", package="HARr")
read_har(fl)
}
