% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordering_functions.R
\name{order_maxmin}
\alias{order_maxmin}
\title{Maximum minimum distance ordering}
\usage{
order_maxmin(locs, lonlat = FALSE, space_time = FALSE, st_scale = NULL)
}
\arguments{
\item{locs}{A matrix of locations. Each row of \code{locs} contains a location, which can
be a point in Euclidean space R^d, a point in space-time R^d x T, 
a longitude and latitude (in degrees) giving a point on the sphere, 
or a longitude, latitude, and time giving a point in the sphere-time domain.}

\item{lonlat}{TRUE/FALSE whether locations are longitudes and latitudes.}

\item{space_time}{TRUE if locations are euclidean space-time locations, 
FALSE otherwise. If set to TRUE, temporal dimension is ignored.}

\item{st_scale}{two-vector giving the amount by which the spatial
and temporal coordinates are scaled. If \code{NULL}, the function
uses the locations to automatically select a scaling.
If set to FALSE, temporal dimension treated as another spatial dimension (not recommended).}
}
\value{
A vector of indices giving the ordering, i.e. 
the first element of this vector is the index of the first location.
}
\description{
Return the indices of an approximation to the maximum minimum distance ordering.
A point in the center is chosen first, and then each successive point
is chosen to maximize the minimum distance to previously selected points
}
\examples{
# planar coordinates
nvec <- c(50,50)
locs <- as.matrix( expand.grid( 1:nvec[1]/nvec[1], 1:nvec[2]/nvec[2] ) )
ord <- order_maxmin(locs)
par(mfrow=c(1,3))
plot( locs[ord[1:100],1], locs[ord[1:100],2], xlim = c(0,1), ylim = c(0,1) )
plot( locs[ord[1:300],1], locs[ord[1:300],2], xlim = c(0,1), ylim = c(0,1) )
plot( locs[ord[1:900],1], locs[ord[1:900],2], xlim = c(0,1), ylim = c(0,1) )

# longitude/latitude coordinates (sphere)
latvals <- seq(-80, 80, length.out = 40 )
lonvals <- seq( 0, 360, length.out = 81 )[1:80]
locs <- as.matrix( expand.grid( lonvals, latvals ) )
ord <- order_maxmin(locs, lonlat = TRUE)
par(mfrow=c(1,3))
plot( locs[ord[1:100],1], locs[ord[1:100],2], xlim = c(0,360), ylim = c(-90,90) )
plot( locs[ord[1:300],1], locs[ord[1:300],2], xlim = c(0,360), ylim = c(-90,90) )
plot( locs[ord[1:900],1], locs[ord[1:900],2], xlim = c(0,360), ylim = c(-90,90) )

}
