% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TestStatistic_BetaSBM.R
\name{graphchi_BetaSBM}
\alias{graphchi_BetaSBM}
\title{Computation of the chi-square test statistic for goodness-of-fit, under beta-SBM}
\usage{
graphchi_BetaSBM(G, C, p_mle)
}
\arguments{
\item{G}{an igraph object which is an undirected graph with no self loop}

\item{C}{a positive integer vector of size n for block assignments of each node; from 1 to K (no of blocks)}

\item{p_mle}{a matrix with the MLE estimates of the edge probabilities}
}
\value{
A numeric value
\item{teststat_val}{The value of the chi-square test statistic}
}
\description{
\code{graphchi_BetaSBM} obtains the value of the chi-square test statistic required for the goodness-of-fit of a beta-SBM (Karwa et al. (2023))
}
\examples{
RNGkind(sample.kind = "Rounding")
set.seed(1729)

# We model a network with 3 even classes
n1 = 2
n2 = 2
n3 = 2

# Generating block assignments for each of the nodes
n = n1 + n2 + n3
class = rep(c(1, 2, 3), c(n1, n2, n3))

# Generating the adjacency matrix of the network
# Generate the matrix of connection probabilities
cmat = matrix(
  c(
    0.80, 0.5, 0.5,
    0.5, 0.80, 0.5,
    0.5, 0.5, 0.80
  ),
  ncol = 3,
  byrow = TRUE
)
pmat = cmat / n

# Creating the n x n adjacency matrix
adj <- matrix(0, n, n)
for (i in 2:n) {
  for (j in 1:(i - 1)) {
    p = pmat[class[i], class[j]] # We find the probability of connection with the weights
    adj[i, j] = rbinom(1, 1, p) # We include the edge with probability p
  }
}

adjsymm = adj + t(adj)

# graph from the adjacency matrix
G = igraph::graph_from_adjacency_matrix(adjsymm, mode = "undirected", weighted = NULL)

# mle of the edge probabilities
p.hat = get_mle_BetaSBM (G, class)

# chi-square test statistic values
graphchi_BetaSBM(G, class, p.hat)
}
\seealso{
\code{\link[=goftest_BetaSBM]{goftest_BetaSBM()}} performs the goodness-of-fit test for the beta-SBM, where the values of the chi-square test statistics are required
}
