% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GoMiner.R
\name{checkGeneListVsDB}
\alias{checkGeneListVsDB}
\title{checkGeneListVsDB}
\usage{
checkGeneListVsDB(geneList, ontology, GOGOA3, thresh = 0.5, verbose = FALSE)
}
\arguments{
\item{geneList}{character list of gene names}

\item{ontology}{character string c("molecular_function", "cellular_component", "biological_process")}

\item{GOGOA3}{return value of subsetGOGOA()}

\item{thresh}{numeric acceptance threshold for fraction of gene list matching database identifiers}

\item{verbose}{integer vector representing classes}
}
\value{
returns no value, but may have side effect of aborting the computation
}
\description{
determine if gene list and database contain compatible identifiers
}
\examples{
\dontrun{
# GOGOA3.RData is too large to include in the R package
# so I need to load it from a file that is not in the package.
# Since this is in a file in my own file system, I could not
# include this as a regular example in the package.
# you can generate it using the package 'minimalistGODB'
# or you can retrieve it from https://github.com/barryzee/GO/tree/main/databases
load("/Users/barryzeeberg/personal/GODB_RDATA/goa_human/GOGOA3_goa_human.RData")
checkGeneListVsDB(geneList=cluster52,ontology="biological_process",
 GOGOA3,thresh=0.5,verbose=TRUE)

# supposed to generate error message
load("/Users/barryzeeberg/personal/GODB_RDATA/sgd/GOGOA3_sgd.RData")
checkGeneListVsDB(geneList=xenopusGenes,ontology="biological_process",
 GOGOA3,thresh=0.5,verbose=TRUE)
}

}
