% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile_reactions.R
\name{compile_reactions}
\alias{compile_reactions}
\title{Precompile the reactions}
\usage{
compile_reactions(
  reactions,
  state_ids,
  params,
  buffer_ids = NULL,
  hardcode_params = FALSE,
  fun_by = 10000L,
  debug = FALSE
)
}
\arguments{
\item{reactions}{'\link{reaction}' A list of multiple \code{\link[=reaction]{reaction()}} objects.}

\item{state_ids}{\verb{[character]} The names of the states in the correct order.}

\item{params}{\verb{[named numeric]} Constants that are used in the propensity functions.}

\item{buffer_ids}{\verb{[character]} The order of any buffer calculations that are made as part of the propensity functions.}

\item{hardcode_params}{\verb{[logical]} Whether or not to hardcode the values of \code{params} in the compilation of the propensity functions.
Setting this to \code{TRUE} will result in a minor sacrifice in accuracy for a minor increase in performance.}

\item{fun_by}{\verb{[integer]} Combine this number of propensity functions into one function.}

\item{debug}{\verb{[logical]} Whether to print the resulting C++ code before compiling.}
}
\value{
A list of objects solely to be used by \code{\link[=ssa]{ssa()}}.
\itemize{
\item \code{x[["state_change"]]}: A sparse matrix of reaction effects.
\item \code{x[["reaction_ids"]]}: The names of the reactions.
\item \code{x[["buffer_ids"]]}: A set of buffer variables found in the propensity functions.
\item \code{x[["buffer_size"]]}: The minimum size of the buffer required.
\item \code{x[["function_pointers"]]}: A list of compiled propensity functions.
\item \code{x[["hardcode_params"]]}: Whether the parameters were hard coded into the source code.`
}
}
\description{
By precompiling the reactions, you can run multiple SSA simulations repeatedly
without having to recompile the reactions every time.
}
\examples{
\donttest{
initial_state <- c(prey = 1000, predators = 1000)
params <- c(c1 = 10, c2 = 0.01, c3 = 10)
reactions <- list(
  #        propensity function     effects                       name for reaction
  reaction(~c1 * prey,             c(prey = +1),                 "prey_up"),
  reaction(~c2 * prey * predators, c(prey = -1, predators = +1), "predation"),
  reaction(~c3 * predators,        c(predators = -1),            "pred_down")
)

compiled_reactions <- compile_reactions(
  reactions = reactions,
  state_ids = names(initial_state),
  params = params
)

out <-
  ssa(
    initial_state = initial_state,
    reactions = compiled_reactions,
    params = params,
    method = ssa_exact(),
    final_time = 5,
    census_interval = .001,
    verbose = TRUE
  )

plot_ssa(out)
}

}
