% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_guandl_series.R
\name{get_single_Quandl}
\alias{get_single_Quandl}
\title{Fetches a single time series from Quandl}
\usage{
get_single_Quandl(
  id_in,
  name_in,
  api_key,
  first_date,
  last_date,
  do_cache = TRUE,
  order = "asc",
  collapse = "none",
  transform = "none"
)
}
\arguments{
\item{id_in}{Character vector of ids to grab data. When using a named vector, the name is used to
register the time series. Example: id_in <- c('US GDP' = 'FRED/GDP')}

\item{name_in}{Name of series to fetch}

\item{api_key}{YOUR api key (get your own at <https://www.quandl.com/sign-up-modal?defaultModal=showSignUp>)}

\item{first_date}{First date of all requested series as YYYY-MM-DD (default = Sys.date() - 365)}

\item{last_date}{Last date of all requested series as YYYY-MM-DD (default = Sys.date() - 365)}

\item{do_cache}{Do cache? TRUE (default) or FALSE. Sets the use of package memoise to cache results from the api}

\item{order}{How to order the time series data: 'desc' (descending dates, default) or 'asc' (ascending)}

\item{collapse}{Frequency of time series: 'none' (default), 'daily', 'weekly', 'monthly', 'quarterly', 'annual'}

\item{transform}{Quandl transformation: 'none', 'diff', 'rdiff', 'rdiff_from', 'cumul', 'normalize'.
Details at <https://docs.quandl.com/docs/parameters-2>}
}
\value{
A single dataframe
}
\description{
Fetches a single time series from Quandl
}
\examples{

api_key <- 'YOUR_API_KEY_HERE'
id_in <- c('Inflation argentina' = 'RATEINF/INFLATION_ARG')
\dontrun{
 df <- get_single_Quandl(id_in = id_in, name_in = '',
                         api_key = api_key,
                         first_date = '2010-01-01',
                         last_date = Sys.Date())
 }

}
