% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdfpd_read_fca_zip_file.R
\name{gdfpd.read.fca.zip.file}
\alias{gdfpd.read.fca.zip.file}
\title{Reads a single FCA zip file downloaded from Bovespa}
\usage{
gdfpd.read.fca.zip.file(my.zip.file, folder.to.unzip = tempdir())
}
\arguments{
\item{my.zip.file}{Full path to zip file}

\item{folder.to.unzip}{Folder to unzip files, default = tempdir()}
}
\value{
A list with several dataframes containing financial statements
}
\description{
Reads a single FCA zip file downloaded from Bovespa
}
\examples{

my.f <- system.file('extdata/FCA_9512_PETR_2015-12-31.zip', package = 'GetDFPData')

my.l <- gdfpd.read.fca.zip.file(my.f)
print(my.l)

}
