% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/others.R
\name{par_trans}
\alias{par_trans}
\title{Parallel transport}
\usage{
par_trans(manifold, p1, p2, v)
}
\arguments{
\item{manifold}{Type of manifold (\code{'euclidean'}, \code{'sphere'},
\code{'hyperbolic'}, or \code{'kendall'}).}

\item{p1}{A vector (or column matrix) representing a point on the manifold.}

\item{p2}{A vector (or column matrix) representing a point on the manifold.}

\item{v}{A vector (or column matrix) tangent to \code{p1}.}
}
\value{
A vector tangent to \code{p2}.
}
\description{
Performs \eqn{\Gamma_{p_1 \rightarrow p_2}(v)}, parallel transport along the
unique minimizing geodesic connecting \eqn{p_1} and \eqn{p_2}, if it exists,
on the given manifold.
}
\details{
On the sphere, there is no unique minimizing geodesic connecting \eqn{p_1}
and \eqn{-p_1}.
}
\examples{
p1 <- matrix(rnorm(10), ncol = 2)
p1 <- p1[, 1] + (1i) * p1[, 2]
p1 <- (p1 - mean(p1)) / norm(p1 - mean(p1), type = '2') # project onto pre-shape space
p2 <- matrix(rnorm(10), ncol = 2)
p2 <- p2[, 1] + (1i) * p2[, 2]
p2 <- (p2 - mean(p2)) / norm(p2 - mean(p2), type = '2') # project onto pre-shape space
p3 <- matrix(rnorm(10), ncol = 2)
p3 <- p3[, 1] + (1i) * p3[, 2]
p3 <- (p3 - mean(p3)) / norm(p3 - mean(p3), type = '2') # project onto pre-shape space
v <- log_map('kendall', p1, p3)
par_trans('kendall', p1, p2, v)

}
\references{
Fletcher, P. T. (2013). Geodesic regression and the theory of
  least squares on Riemannian manifolds. International Journal of Computer
  Vision, 105, 171-185.

  Cornea, E., Zhu, H., Kim, P. and Ibrahim, J. G. (2017). Regression models
  on Riemannian symmetric spaces. Journal of the Royal Statistical Society:
  Series B, 79, 463-482.

  Calinon, S. (2020). Gaussians on Riemannian manifolds: Applications for
  robot learning and adaptive control. IEEE Robotics & Automation Magazine,
  27, 33-45.

  Shin, H.-Y. and Oh H.-S. (2020). Robust Geodesic Regression. <arXiv:2007.04518>
}
\author{
Ha-Young Shin
}
