% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_sensitivity.R
\name{compute_sensitivity}
\alias{compute_sensitivity}
\title{Compute response sensitivity to parameter variation.}
\usage{
compute_sensitivity(
  x,
  vary = c("age", "obesity", "css_params", "fit_params", "C_ext"),
  max_mult = NULL
)
}
\arguments{
\item{x}{GeoTox object.}

\item{vary}{which parameter to vary.}

\item{max_mult}{input for \link{calc_concentration_response} step.}
}
\value{
output from \link{calc_concentration_response}
}
\description{
Compute response sensitivity to parameter variation.
}
\examples{
# Use a subset of the package data for demonstration purposes
set.seed(2357)
n <- 10 # Population size
m <- 5 # Number of regions
idx <- if (m < 100) sample(1:100, m) else 1:100

# Create GeoTox object and populate required fields
geoTox <- GeoTox() |>
  # Simulate populations for each region
  simulate_population(age = split(geo_tox_data$age, ~FIPS)[idx],
                      obesity = geo_tox_data$obesity[idx, ],
                      exposure = split(geo_tox_data$exposure, ~FIPS)[idx],
                      simulated_css = geo_tox_data$simulated_css,
                      n = n) |>
  # Estimated Hill parameters
  set_hill_params(geo_tox_data$dose_response |>
                    fit_hill(assay = "endp", chem = "casn") |>
                    dplyr::filter(!tp.sd.imputed, !logAC50.sd.imputed))

# Sensitivity computations can now be done
age_resp <- geoTox |> compute_sensitivity()
obesity_resp <- geoTox |> compute_sensitivity(vary = "obesity")
}
