% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeoRarefaction_MultiTaxa.R
\name{GeoRarefaction_MultiTaxa}
\alias{GeoRarefaction_MultiTaxa}
\title{Calculates six geographic range measures at resampled a number of time from specified sample sizes}
\usage{
GeoRarefaction_MultiTaxa(nLocCut = 3, OccMatrix, TaxaStart, LongPos = 1,
  LatPos = 2, iter = 10, CellSize = 5, longBounds = c(-180, 180),
  latBounds = c(-90, 90), steps = c(1, 50, 40, 30, 20, 10, 5),
  replacePts = FALSE)
}
\arguments{
\item{nLocCut}{- The minimum number of locations a taxon must be seen at to have geographic range measures calculated}

\item{OccMatrix}{- A matrix where columns are taxon occurrences and also having at least longitude and latitude values}

\item{TaxaStart}{- The column index value where taxon records start}

\item{LongPos}{- The column index value of longitudinal coordinates in the OccMatrix}

\item{LatPos}{- The column index value of latitudinal coordinates in the OccMatrix}

\item{iter}{- The number of times a taxon's locations are resampled at each step size}

\item{CellSize}{- The size of each cell in degree X degree}

\item{longBounds}{- Array of longitudinal boundaries in decimal degrees}

\item{latBounds}{- Array of latitudinal boundaries in decimal degrees}

\item{steps}{- Array of the values representing the number of points to be subsampled for each taxon}

\item{replacePts}{- A logical value indicating whether points are allowed to be sampled more than once during each subsampling iteration}
}
\value{
Returns a vector where each element is a taxon with a list of each geographic range measure as a separate matrix of values. Measures include minimum spanning tree distance, minimum convex hull area, maxmimum pairwise great circle distance, latitudinal range, longitudinal range, and number of degree X degree cells occupied.
}
\description{
Calculates six geographic range measures at resampled a number of time from specified sample sizes
}
\details{
The nLocCut parameter is the minimum number of distinct geographic locations a taxon must be observed at to have geographic range measures calcualted, if below retruns NA.
The steps parameter typically begins with a 1 representing that all points should be used in calculations but this is not required.
The replacePts parameter must be set to TRUE if any of the steps require a greater number of points to be sampled than there are actual locations for a taxon, otherwise the function will fail.
}
\note{
If PEE values are to be calculated as a next step the steps parameter needs to have a value of 1 as its first value
}
\examples{
\dontrun{
data(BivalvePBDB)
BivalveMatrix<-CoordList_PBDB(BivalvePBDB)
GeoRarefaction_MultiTaxa(nLocCut=20,OccMatrix=BivalveMatrix,TaxaStart=3,replacePts=TRUE)
}
}
\seealso{
See the velociraptr package for details of the downloadPBDB() function
}
