% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CHullArea.R
\name{CHullArea}
\alias{CHullArea}
\title{Performs Convex Hull area calculation}
\usage{
CHullArea(longs, lats)
}
\arguments{
\item{longs}{- Array of longitudinal occurrence values in decimal degrees}

\item{lats}{- Array of latitudinal occurrence values in decimal degrees}
}
\value{
Returns area of a set of coordinates
}
\description{
Performs Convex Hull area calculation
}
\details{
Uses the cylindrical equal area projection in order to check if the minimum convex hull wraps around the prime meridian
}
\note{
Relies on the 'sp' package for the Polygon and chull function
}
\examples{
longs<-c(-12,23,55)
lats<-c(34,22,30)
CHullArea(longs,lats)
}
