% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importBed.R
\name{importBed}
\alias{importBed}
\title{Importing a Bed File.}
\usage{
importBed(file, header = FALSE, sep = "\\t")
}
\arguments{
\item{file}{Specifies the filename/path}

\item{header}{Logical, is a header present}

\item{sep}{Column separator}
}
\value{
A \code{data.frame}
}
\description{
This function imports a standard bed file
}
\details{
This function imports a standard bed-file into a data.frame. It is basically a convenience wrapper around \code{read.table}. However,
if no header lines is given, this function automatically assigns the column names, as they are given in the bed-specification on the
Ensembl page here: https://www.ensembl.org/info/website/upload/bed.html
}
\examples{
   
 # Define here the location on HDD for the example file
   fpath <- system.file("extdata","example.bed", package="GenomicTools.fileHandler")
 # Import the example bed file  
   bedFile <- importBed(file=fpath)
 
}
\seealso{
[exportBed], [read.table]
}
\author{
Daniel Fischer
}
