% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_iso_female.R
\name{iso_female_ancestry}
\alias{iso_female_ancestry}
\title{Create isofemale}
\usage{
iso_female_ancestry(
  source_pop = NA,
  n = 1,
  inbreeding_pop_size = 100,
  run_time = 2000,
  morgan = 1,
  num_threads = 1,
  verbose = FALSE
)
}
\arguments{
\item{source_pop}{Source population from which isofemales are generated}

\item{n}{Number of isofemales to be generated}

\item{inbreeding_pop_size}{Population size of the population used to generate
homozygous individuals}

\item{run_time}{Maximum runtime used for inbreeding}

\item{morgan}{Size of the chromosome in Morgan (e.g. the number of crossovers
during meiosis)}

\item{num_threads}{number of threads. Default is 1. Set to -1 to use all
available threads}

\item{verbose}{Displays verbose output if TRUE. Default value is FALSE}
}
\value{
A list of length \code{n}, where each entry is a fully homozygous
isofemale.
}
\description{
Creates isofemale individuals, given a population
}
\details{
To create an isofemale, two individuals are randomly picked from
the source population. Using these two individuals, a new population is
seeded, of size \code{inbreeding_pop_size}. Then, this population is allowed
to inbreed until either \code{run_time} is reached, or until all individuals
are homozygous and genetically identical, whatever happens first.
}
