% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_upset.R
\name{plot_upset}
\alias{plot_upset}
\title{Plot Feature Overlaps Using UpSet Plots}
\usage{
plot_upset(pipeline_results, custom_lists = NULL)
}
\arguments{
\item{pipeline_results}{A PipelineResults object containing the fitted pipelines, cross-validation results, selected features,
mean performance, and mean feature importances.}

\item{custom_lists}{An optional named list of character vectors. Each character vector should contain feature names.
The names of the list will be used as names in the UpSet plots.}
}
\value{
A named list containing two UpSet plots:
\itemize{
\item @field inbuilt_importance: An UpSet plot visualizing overlaps of inbuilt feature importances.
\item @field permutation_importance: An UpSet plot (if permutation importance is available) visualizing overlaps of permutation importances.
Each plot provides an interactive way to explore the intersections and unique elements of the feature lists.
}
}
\description{
This function produces separate UpSet plots for inbuilt feature importances and permutation importances,
allowing you to visualize the overlap of feature lists. Optionally, you can include custom lists.
}
\examples{
\donttest{
# Mock data for PipelineResults
pipeline_results <- new("PipelineResults",
                        inbuilt_feature_importance = list(
                          Method1 = data.frame(feature = c("gene1", "gene2", "gene3")),
                          Method2 = data.frame(feature = c("gene2", "gene4"))),
                        permutation_importance = list(
                          Method1 = data.frame(feature = c("gene1", "gene5")),
                          Method2 = data.frame(feature = c("gene3", "gene6"))))

# Mock custom lists
custom_lists <- list("custom1" = c("gene1", "gene2"), "custom2" = c("gene3", "gene4"))

# Generate UpSet plots
result <- plot_upset(pipeline_results, custom_lists)
print(result$inbuilt_importance)
print(result$permutation_importance)
}
}
