% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example_gtf.R
\name{tiny_example_gtf_files}
\alias{tiny_example_gtf_files}
\title{Tiny example GTF files}
\format{
Two external GTF files.
}
\source{
Generated manually for testing purposes.
}
\description{
These are minimal GTF files used for examples and testing within the package.
\itemize{
\item \strong{gencode.v1.example.gtf.gz} contains two genes:
\itemize{
\item GeneA: a single-exon, unspliced gene.
\item GeneB: a spliced gene with two transcripts and multiple exons.
}
\item \strong{gencode.v2.example.gtf.gz} contains the same two genes as in \code{gencode.v1.example.gtf.gz} plus:
\itemize{
\item GeneC: a new spliced gene with multiple transcripts and many exons.
}
}

These files are stored in the \verb{inst/extdata/} directory and can be accessed using
\code{system.file("extdata", "gencode.v1.example.gtf.gz", package = "GencoDymo2")}
or
\code{system.file("extdata", "gencode.v2.example.gtf.gz", package = "GencoDymo2")}.
}
\examples{
tiny_v1_path <- system.file("extdata", "gencode.v1.example.gtf.gz", package = "GencoDymo2")
tiny_v2_path <- system.file("extdata", "gencode.v2.example.gtf.gz", package = "GencoDymo2")

gtf1 <- load_file(tiny_v1_path)
head(gtf1)

gtf2 <- load_file(tiny_v2_path)
head(gtf2)
}
\seealso{
\code{\link{load_file}}
}
