% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GaussianMixtureInv.R
\name{GaussianMixtureInv}
\alias{GaussianMixtureInv}
\title{Inverse distribution function of a mixture of Gaussian univariate distributions}
\usage{
GaussianMixtureInv(p, mu, sigma, w)
}
\arguments{
\item{p}{Points in (0,1) at which the distribution function is computed (nx1);}

\item{mu}{vector of means for each regime (r x 1);}

\item{sigma}{vector of standard deviations for each regime (r x 1);}

\item{w}{vector of the probability of each regime (r x 1).}
}
\value{
\item{q}{values of the quantile function}
}
\description{
This function computes the inverse distribution function of a mixture of
Gaussian univariate distributions
}
\examples{
mu <- c(-0.3 ,0.7) ; sigma <- c(0.15,0.05); w <-c(0.8, 0.2);
p <- seq(0.01, 0.99, by = 0.01)
q <- GaussianMixtureInv(p,mu,sigma,w)
plot(p,q,type="l")

}
\author{
Bouchra R Nasri  and Bruno N Rémillard, January 31, 2019
}
