% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IM_nodep.R
\name{IM_nodep}
\alias{IM_nodep}
\title{IM_nodep Function: Calculate Influence Measure for Features Without Dependency}
\usage{
IM_nodep(Xdata, Ydata)
}
\arguments{
\item{Xdata}{Matrix. A dataset where rows represent observations and columns represent features.}

\item{Ydata}{Vector. The response variable associated with each row in \code{Xdata}.}
}
\value{
A vector of influences for each feature.
}
\description{
The \code{IM_nodep} function calculates the influence measure of equation (2) in Davila-Pena et al. (2024)
when the partition set is P=\{\{1\},\{2\},\{3\},\{4\}\}, which is equivalent to the influence measure in Datta et al. (2015).
}
\details{
The \code{IM_nodep} function calculates the weighted average of the number of times a change in
the value of a feature influences the response value.
}
\examples{
# Example usage from Example 5.2 in Davila-Pena et al. (2024):

library(CoopGame)
n.user <- 16
Xdata <- createBitMatrix(4)[,-5]
Xdata <- rbind(c(0,0,0,0),Xdata)
Ydata <- rep(0,n.user)
Ydata[1+c(10,11,13,14,15)] <- 1

# Scenario 1:
IM_nodep(Xdata,Ydata)

}
\references{
Datta, A., Datta, A., Procaccia, A., & Zick, Y. (2015). \emph{Influence in classification via cooperative game theory}. Proceedings of the Twenty–fourth International Joint Conference on Artificial Intelligence, 511–517. \url{https://www.ijcai.org/Proceedings/15/Papers/078.pdf}.

Davila-Pena, L., Saavedra-Nieves, A., & Casas-Méndez, B. (2024). \emph{On the influence of dependent features in classification problems: a game-theoretic perspective}. arXiv preprint. \doi{10.48550/arXiv.2408.02481}.
}
