% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GTE.R
\name{Select.HBGs}
\alias{Select.HBGs}
\title{Select highly batch-sensitive genes (HBGs) under a group variable.}
\usage{
Select.HBGs(GTE, bins = 0.1, gte.ratio = 0.95)
}
\arguments{
\item{GTE}{GTE result.}

\item{bins}{Bins.}

\item{gte.ratio}{Ratio of selected HBGs to the total GTE.}
}
\value{
Identified HBGs.
}
\description{
Select highly batch-sensitive genes (HBGs) under a group variable.
}
\examples{
# GTE is the result of Run.GroupTechEffects function.
data_file <- system.file("extdata", "GTE_ct.rds", package = "GTEs")
GTE_ct <- readRDS(data_file)
HBGs <- Select.HBGs(GTE_ct)
}
