% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mpermut.R
\name{Mpermut}
\alias{Mpermut}
\title{Basic description}
\usage{
Mpermut(G,W,obs)
}
\arguments{
\item{G}{a list of all groups}

\item{W}{the weight matrix}

\item{obs}{the observed statistic}
}
\value{
the pvalue
}
\description{
Given the groups and the observed statistic, this function returns the pvalue.
}
\examples{
G=list()
set.seed(1)
n1=20;n2=40
N=n1+n2;
G[[1]]=c(1:n1);G[[2]]=c((n1+1):(n1+n2));
d=10
mu1=rep(0,d)
mu2=mu1+0.1
true.cov1=0.4^(abs(outer(1:d,1:d,"-")))
true.cov2=0.4^(abs(outer(1:d,1:d,"-")))
sam1=MASS::mvrnorm(n=n1,mu=mu1,Sigma=true.cov1)
sam2=MASS::mvrnorm(n=n2,mu=mu2,Sigma=true.cov2)
Data=rbind(sam1,sam2)
Dist=philentropy::distance(Data, method = "euclidean")
Dist[lower.tri(Dist)] <- NA
Dist[diag(Dist)] <- NA
counts=compbypath(G,Hpath(1,N,Dist))
W=Weight(G)
#W[i,j]=0 #if we donot consider this relevance between sample i and sample j
C=counts$EC
Z=(C-W$mean)*W$weight
obs=min(Z[!is.na(Z)])
Mpermut(G,W$weight,obs)
}
