% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRCdesigns.R
\name{SCGRC_I}
\alias{SCGRC_I}
\title{Structurally Complete Generalized Row Column Designs of Series-I}
\usage{
SCGRC_I(v)
}
\arguments{
\item{v}{Odd number(>3)}
}
\value{
This function generates structurally complete GRC designs for odd number of treatment as well as the information matrix for estimating elementary treatment contrast.
}
\description{
This series generated through initial columns. The resulting GRC design is a row-column design with two units per cell and with p = t (>1) rows of size 2(2t+1), q = (2t+1) columns of size 2t, k = 2 and r = 2t replications.
}
\examples{
library(GRCdesigns)
SCGRC_I(5)
}
\references{
1) Datta, A., Jaggi, S., Varghese, C. and Varghese, E. (2014). Structurally incomplete row-column designs with multiple units per cell. Statistics and Applications, 12(1&2), 71-79.

2)Datta, A., Jaggi, S., Varghese, C. and Varghese, E. (2015). Some series of row-column designs with multiple units per cell. Calcutta Statistical Association Bulletin, 67, ( 265-266), 89-99.

3)Datta, A., Jaggi, S., Varghese, C. and Varghese, E.  (2016). Series of incomplete row-column designs with two units per cell. Advances in Methodology and Statistics. 13(1), 17-25.
}
