% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_w_corr.R
\name{compute_w_corr}
\alias{compute_w_corr}
\title{Compute  weighted covariate balance}
\usage{
compute_w_corr(w, covariate, weight)
}
\arguments{
\item{w}{A vector of observed continuous exposure variable.}

\item{covariate}{A data frame of observed covariates variable.}

\item{weight}{A vector of weights.}
}
\value{
The function returns a list saved the measure related to covariate balance
\code{absolute_corr}: the absolute correlations for each pre-exposure
covairates;
\code{mean_absolute_corr}: the average absolute correlations for all
pre-exposure covairates.
}
\description{
Computes weighted covariate balance for given data sets.
}
\examples{
set.seed(639)
n <- 100
mydata <- generate_synthetic_data(sample_size=100)
year <- sample(x=c("2001","2002","2003","2004","2005"),size = n,
 replace = TRUE)
region <- sample(x=c("North", "South", "East", "West"),size = n,
 replace = TRUE)
mydata$year <- as.factor(year)
mydata$region <- as.factor(region)
mydata$cf5 <- as.factor(mydata$cf5)
cor_val <- compute_w_corr(mydata[,2],
                          mydata[, 3:length(mydata)],
                          runif(n))

print(cor_val$mean_absolute_corr)

}
