% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landscape.R
\name{make_landscape}
\alias{make_landscape}
\title{Landscape initialisation}
\usage{
make_landscape(
  model,
  rows,
  cols,
  cell_types = 1,
  cell_val_mn = 1,
  cell_val_sd = 0,
  cell_val_max = 1,
  cell_val_min = 0,
  layers = 3,
  ownership = FALSE,
  owners = 4,
  public_land = 0,
  ownership_var = 0
)
}
\arguments{
\item{model}{The type of model being applied (Currently only individual-based
-- i.e., 'agent-based' -- models are allowed)}

\item{rows}{The dimension of the other side of the landscape (e.g., Longitude)}

\item{cols}{The dimension of one side of the landscape (e.g., Latitude)}

\item{cell_types}{Scalar or vector of all possible types of landscape cells}

\item{cell_val_mn}{Mean cell value (e.g., defining crop output on a cell)}

\item{cell_val_sd}{Standard devation of cell values on a landscape}

\item{cell_val_max}{The maximum value of a cell}

\item{cell_val_min}{The minimum value of a cell}

\item{layers}{The number of layers in the 3D landscape (should usually be 3)}

\item{ownership}{A TRUE or FALSE whether land should be owned by stakeholders}

\item{owners}{The number of stakeholders in the model that own land}

\item{public_land}{The proportion of landscape cells that are not owned}

\item{ownership_var}{Does distribution of land vary among users? >=0, <1}
}
\value{
the_land A cols by rows landscape with randomly distributed cell types
}
\description{
Initialise the landscape of the G-MSE model.
}
\examples{
land <- make_landscape(model = "IBM", rows = 10, cols = 10, cell_types = 1, 
cell_val_mn = 1, cell_val_sd =  0)
}
