% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goodness.of.fit.R
\name{goodness.of.fit}
\alias{goodness.of.fit}
\title{Goodness of fit for the general GMCM}
\usage{
goodness.of.fit(theta, u, method = c("AIC", "BIC"), k = 2)
}
\arguments{
\item{theta}{A \code{list} of parameters as defined in \code{\link{rtheta}}.
For t this function, it will usually be the output of
\code{\link{fit.full.GMCM}}.}

\item{u}{An \code{n} by \code{d} matrix of marginally uniform observations.
Rows corresponds to observations and columns to the dimensions of the
variables. I.e. these are often ranked and scaled test statistics or other
observations.}

\item{method}{A \code{character} of length 1 which specifies the goodness of
fit to compute. Default is "AIC". "BIC" is also a option.}

\item{k}{A integer specifying the default used constant "k" in AIC. See
\code{\link{AIC}}.}
}
\value{
A single number giving the goodness of fit as requested.
}
\description{
Compute goodness of fit as described in \code{\link{AIC}}. The number of
parameters used correspond to the number of variables free to vary in the
general model.
}
\examples{
set.seed(2)
data(u133VsExon)
u <- Uhat(u133VsExon[sample(19577, 500), ])  # Subset for faster fitting
theta1 <- fit.full.GMCM(u, m = 2, method = "L-BFGS")
goodness.of.fit(theta1, u)  # AIC
goodness.of.fit(theta1, u, method = "BIC")
\dontrun{
theta2 <- fit.full.GMCM(u, m = 3, method = "L-BFGS")
goodness.of.fit(theta2, u)
goodness.of.fit(theta2, u, method = "BIC")
}
}
