% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{estimate}
\alias{estimate}
\title{estimate}
\usage{
estimate(rand, tr, y, iterations = 5000L)
}
\arguments{
\item{rand}{An integer or logical vector specifying whether each observation is from the random (1) or self-selection (0) arm of the experiment.}

\item{tr}{An integer or logical vector specifying whether each observation was treated (1) or control (0), regardless of the arm of the experiment.}

\item{y}{A numeric vector specifying outcome values.}

\item{iterations}{An integer specifying the number of bootstrap iterations used to estimate standard errors.}
}
\value{
A data.frame containing the following variables:
\itemize{
\item \code{Effect}, a character vector of effect names (\dQuote{t}, \dQuote{t_s}, \dQuote{t_n}, \dQuote{naive})
\item \code{Estimate}, a numeric vector of effect estimates
\item \code{SE}, a numeric vector of bootstrapped standard errors
\item \code{t}, a t-statistic for the effect
\item \code{p}, a two-tailed p-value
}
The return value will also carry an attribute \dQuote{alpha}, indicating the estimated proportion \eqn{\alpha}.
}
\description{
Estimators for Hybrid Experiments
}
\details{
The package provides R implementations of the treatment effect estimators for hybrid (self-selection) experiments, as developed by Gaines and Kuklinski (2011). These functions estimate local average treatment effects for unobserved population subgroups inclined and disinclined to be treated, as revealed by a three-condition (two-arm) experimental design. In the design, participants are randomly assigned to one of three conditions: 1) treatment (T), 2) control (C), or 3) self-selection (S) of treatment or control. The design enables the estimation of three treatment effects:
\enumerate{
  \item First, the sample average treatment effect is estimated from conditions (1) and (2) as:\\
          \eqn{\hat{t} = \bar{Y}_{T} - \bar{Y}_{C}}
  \item The effect for those inclined to choose treatment is given by:\\
          \eqn{\hat{t}_s = \frac{\bar{Y}_{S} - \bar{Y}_{C}}{\hat{\alpha}}}
        where \eqn{\hat{\alpha}} is the observed proportion of individuals in group S that choose T (rather than C).
  \item The effect for those disinclined to choose treatment (or, equivalently, inclined to choose control) is given by:\\
           \eqn{\hat{t}_n = \frac{\bar{Y}_{T} - \bar{Y}_{S}}{1-\hat{\alpha}}}
}
By definition, the sample average treatment effect is an average of the other two effects.
}
\examples{
# create fake data
set.seed(12345)
d <- 
data.frame(rand = c(rep(1, 200), rep(0, 100)),
           tr = c(rep(0, 100), rep(1, 100), rep(0, 37), rep(1, 63)),
           y = c(rnorm(100), rnorm(100) + 1, rnorm(37), rnorm(63) + 3))

# estimate effects
estimate(rand = d$rand, tr = d$tr, y = d$y)
}
\author{
Thomas J. Leeper <thosjleeper@gmail.com>
}
\references{
Brian J. Gaines and James H. Kuklinski, (2011), "Experimental Estimation of Heterogeneous Treatment Effects Related to Self-Selection," \emph{American Journal of Political Science} 55(3): 724-736.
}
\seealso{
\code{\link{ajps}}
}

