\name{dataDE}
\alias{dataDE}
\docType{data}

\title{Simulated data with two endogenous variables}

\description{Simulated data with two endogenous variables and binary outcome.}

\usage{
data(dataDE)
}


\format{\code{dataDE} is a 2000 row data frame with the following columns: 

\describe{
         
\item{y1}{First endogenous variable.}
\item{y2}{Second endogenous variable.}
\item{y3}{Binary outcome.}
\item{x1, x2}{Covariates.}
\item{x3}{Covariate influencing only \code{y1}.}
\item{x4}{Covariate influencing only \code{y2}.}


}

}

\examples{

# Data have been simulated as shown below

n  <- 2000
x1 <- round(runif(n))
x2 <- runif(n)
x3 <- runif(n)
x4 <- rnorm(n)
u  <- rnorm(n)

y1 <- ifelse(-1.55 +               x1 - x2 + x3 + u + rnorm(n) > 0, 1, 0)
y2 <- ifelse(-0.25 -           0.5*x1 + x2 + x4 + u + rnorm(n) > 0, 1, 0)
y3 <- ifelse(-0.75 + 0.5*y1 - y2 + x1 + x2      + u + rnorm(n) > 0, 1, 0)

dataDE <- data.frame(y1, y2, y3, x1, x2, x3, x4)

}



