% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_fitGIMMEgVAR.R
\name{fitGIMMEgVAR}
\alias{fitGIMMEgVAR}
\title{FIT 'GIMMEgVAR'}
\usage{
fitGIMMEgVAR(
  inData,
  variableNames,
  gimmeGVARThreshold = 0.5,
  nLambda = 50,
  verbose = TRUE,
  gamma = 0.5,
  scale = TRUE,
  lambda_beta,
  lambda_kappa,
  maxit.in = 100,
  maxit.out = 100,
  deleteMissings = TRUE,
  penalize.diagonal = TRUE,
  lambda_min_kappa = 0.05,
  lambda_min_beta = lambda_min_kappa,
  mimic = c("current", "0.1.2", "0.1.4", "0.1.5", "0.2"),
  beepvar,
  dayvar,
  idvar,
  lags = 1,
  centerWithin = TRUE,
  likelihood = c("unpenalized", "penalized"),
  logicals,
  RES_matrixData,
  outputPath,
  labelNames = variableNames
)
}
\arguments{
\item{inData}{A matrix or data frame containing repeated measures (rows) on a set of variables (columns).
Must not contain missing data.}

\item{variableNames}{The vector containing name of variables to be analyzed}

\item{gimmeGVARThreshold}{The cutoff value for group-level paths. Defaults to .50, indicating
that a path must be non-zero across >= .50% of individuals to be
included as a group-level path.}

\item{nLambda}{The number of both lambda parameters to test. Defaults to 50,
which results in 2500 models to evaluate.}

\item{verbose}{Logical, should a progress bar be printed to the console?}

\item{gamma}{The EBIC hyper-parameter. Set to 0 to use regular BIC.}

\item{scale}{Logical, should responses be standardized before estimation?}

\item{lambda_beta}{An optional vector of lambda_beta values to test.
Set lambda_beta = 0 argument and lambda_kappa = 0 for unregularized estimation.}

\item{lambda_kappa}{An optional vector of lambda_kappa values to test.
Set lambda_beta = 0 argument and lambda_kappa = 0 for unregularized estimation.}

\item{maxit.in}{Maximum number of iterations in the inner loop (computing beta)}

\item{maxit.out}{Maximum number of iterations in the outer loop}

\item{deleteMissings}{Logical, should missing responses be deleted?}

\item{penalize.diagonal}{Logical, should the diagonal of beta be penalized (i.e., penalize auto-regressions)?}

\item{lambda_min_kappa}{Multiplier of maximal tuning parameter for kappa}

\item{lambda_min_beta}{Multiplier of maximal tuning parameter for beta}

\item{mimic}{Allows one to mimic earlier versions of 'graphicalVAR'}

\item{beepvar}{String indicating assessment beep per day (if missing, is added).
Adding this argument will cause non-consecutive beeps to be treated as missing!}

\item{dayvar}{String indicating assessment day. Adding this argument makes sure that the first measurement of a day is not
regressed on the last measurement of the previous day.
IMPORTANT: only add this if the data has multiple observations per day.}

\item{idvar}{String indicating the subject ID}

\item{lags}{Vector of lags to include}

\item{centerWithin}{logical, should subject data be within-person centered before estimating fixed effects?}

\item{likelihood}{Should likelihood be computed based on penalized contemporaneous matrix or}

\item{logicals}{Logical matrices that determine which elements of the beta and kappa matrices will be regularized
when fititng 'GIMMEgVAR'.  The matrices are determined in the algorithm by obtaining counts across all fitted individual
network results for beta and kappa, respectively.  Elements with proportions >= gimmeGVARThreshold value
will not be regularized when fitting 'GIMMEgVAR'.}

\item{RES_matrixData}{List containing results of fitting individual 'graphicalVAR' to each individual.}

\item{outputPath}{The user specified path to the directory where results files should be stored.}

\item{labelNames}{Vector of names used to label nodes in Network graph. Defaults to variable names if no
vector is supplied.}
}
\description{
This function fits 'GIMMEgVAR' using the original input data supplied by the user
and the logical matrices that result across people after fitting individual
'graphicalVAR'.  The logical matrices are determined via the gimmeThreshold specified
by the user
}
\details{
The user can pass in additional 'graphicalVAR' options as specified in the R
package 'graphicalVAR' created by Sacha Epskamp.  See 'graphicalVAR' documentation
for details.

The following results are returned in the 'GIMMEgVAR' Files directory:
(1) Data frames containing individual paths.  These are the person-specific results
for each individual obtained by not regularizing the group paths indicated
by the logical matrices for both beta and kappa.  They are prefaced
RESULTS_GIMMEgVAR_SUBJECT_.

(2) Data frames that indicate the proportion of paths across individuals:
These are dataframes containing the proportion of paths present across
individuals after fitting 'GIMMEgVAR'.  These proportions are used to determine
the final group model.  They are named proportionKappa.RData and proportionBeta.RData.

(3) Group path data frames for beta and kappa:
These are dataframes with 1 indicating the presence of a group path and 0 indicating
the absence of a group path.
These data frames are derived from #2 above for both beta and kappa.  They are the
dataframes used to graph the final group models and are prefaced
GIMMEgVAR_RESULTS_GRP_BETA_THRESHOLD_ and GIMMEgVAR_RESULTS_GRP_KAPPA_THRESHOLD_.
The number following threshold indicates the gimmeThreshold used for the analysis.

(4) Final network graphs are added to the gimmegvarFiles folder in .png format.
These contain overlay graphs of the group and individual paths for the beta and
kappa network respectively.
}
