% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_summary_plot.R
\name{summary.gfdmcv}
\alias{summary.gfdmcv}
\title{Print "gfdmcv" object}
\usage{
\method{summary}{gfdmcv}(object, ...)
}
\arguments{
\item{object}{an "gfdmcv" object.}

\item{...}{integer indicating the number of decimal places to be used to present the numerical results, 
It can be named \code{digits} as in the \code{round()} function (see examples).}
}
\value{
No return value, called for side effects.
}
\description{
Prints the summary of the inference methods for CV and MCVs.
}
\details{
The function prints out the information about the significance level, constrast matrices, 
test statistics, \eqn{p}-values, critical values, simultaneous confidence intervals for contrasts
performed by the \code{GFDmcv()} function.
}
\examples{
# Some of the examples may run some time. 
# For more examples, see the documentation of the GFDmcv() function.
data_set <- lapply(list(iris[iris$Species == "setosa", 1:3],
                        iris[iris$Species == "versicolor", 1:3],
                        iris[iris$Species == "virginica", 1:3]),
                   as.matrix)
# estimators and confidence intervals of MCVs and their reciprocals
lapply(data_set, e_mcv)
# contrast matrices
k <- length(data_set)
# Tukey's contrast matrix
h_mct <- contr_mat(k, type = "Tukey")
# centering matrix P_k
h_wald <- contr_mat(k, type = "center") 
\donttest{
# testing without parallel computing
res <- GFDmcv(data_set, h_mct, h_wald)
summary(res, digits = 3)
}

}
