% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_contrast_matrices.R
\name{contr_mat}
\alias{contr_mat}
\title{Contrasts' matrices}
\usage{
contr_mat(k, type = c("center", "Dunnett", "Tukey"))
}
\arguments{
\item{k}{an integer denoting a number of groups}

\item{type}{an character denoting type of contrasts. The possible values are \code{"center"} (default), 
\code{"Dunnett"}, \code{"Tukey"}.}
}
\value{
The matrix of contrasts.
}
\description{
The output are different contrast matrices, namely the centering matrix as well as the matrices of Dunnett's and Tukey's contrasts for given number of groups.
}
\details{
The centering matrix is \eqn{\mathbf{P}_k = \mathbf{I}_k  - \mathbf{J}_k/k}, where 
\eqn{\mathbf{I}_k} is the unity matrix and \eqn{\mathbf{J}_k=\mathbf{1}\mathbf{1}^{\top} \in R^{k\times k}} consisting of \eqn{1}'s only.
The matrix of Dunnett's contrasts: \deqn{\left(\begin{array}{rrrrrr} 
-1 & 1 & 0 & \ldots & \ldots  & 0\\			
-1 & 0 & 1 & 0 & \ldots  & 0 \\
\vdots & \vdots & \vdots & \vdots & \vdots & \vdots  \\
-1 & 0 & \ldots & \ldots & 0  &  1\\
\end{array}\right)\in R^{(k-1)\times k}.} 
The matrix of Tukey's contrasts: \deqn{\left(\begin{array}{rrrrrrr}
-1 & 1 & 0 & \ldots & \ldots & 0 & 0\\		
-1 & 0 & 1 & 0 & \ldots & \ldots & 0 \\
\vdots & \vdots & \vdots & \vdots & \vdots & \vdots & \vdots \\
-1 & 0 & 0 & 0 & \ldots  & \ldots & 1 \\
0 & -1 & 1 & 0 &\ldots & \ldots & 0 \\
\vdots & \vdots & \vdots & \vdots & \vdots & \vdots & \vdots \\
0 & \ldots & \ldots & \ldots & 0 & -1 &  1\\
\end{array}\right)\in R^{{k \choose 2}\times k}.}
}
\examples{
contr_mat(4, type = "center")
contr_mat(4, type = "Dunnett")
contr_mat(4, type = "Tukey")

}
\references{
Ditzhaus M., Smaga L. (2022) Permutation test for the multivariate coefficient of variation in factorial designs. 
Journal of Multivariate Analysis 187, 104848.

Ditzhaus M., Smaga L. (2023) Inference for all variants of the multivariate coefficient of variation in factorial designs. Preprint https://arxiv.org/abs/2301.12009.

Dunnett C. (1955) A multiple comparison procedure for comparing several treatments with a control. Journal of the American Statistical Association 50, 1096-1121.

Tukey J.W. (1953) The problem of multiple comparisons. Princeton University.
}
