% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEmetrics_blup.R
\name{GEmetrics_blup}
\alias{GEmetrics_blup}
\title{Best linear unbiased prediction of genotype-by-environment (GE) metrics}
\usage{
GEmetrics_blup(G_hat, metric, P = NULL)
}
\arguments{
\item{G_hat}{a matrix of best linear unbiased prediction of environment-specific
breeding values for N genotypes (as rows) in J environments (as columns)}

\item{metric}{a character string indicating what GE metric to consider:
"Ecovalence", "EnvironmentalVar", "FinlayWilkRegression", "LinBinns"}

\item{P}{(optional) a square conditional variance matrix of environment-specific
breeding values of dimension NJxNJ, where each row block of size N correspond
to an environment and the rows of each block correspond to genotypes}
}
\value{
a vector of size N with best linear unbiased prediction of
the GE metric
}
\description{
This function calculates the best linear unbiased prediction of
the following GE metrics: ecovalence, environmental variance, Finlay and
Wilkinson regression and Lin and Binns superiority measure.
Ignoring the P matrix resumes to ignoring the condition
variance term in the calculation
}
\examples{
## Set seed for reproductibility
set.seed(123)

## Load "wheat" dataset from BGLR
data("wheat",package = "BGLR")

## Generate a design data frame for all genotypes in 5 environments
Design <- expand.grid(Genotype=rownames(wheat.A),Environment=paste0("Env",1:5))

## Set sparseness by discarding 80\% of the combinations
Design <- Design[-sample(nrow(Design),round(nrow(Design)*4/5)),]

## Simulate phenotypic data with default parameter values
DataSim <- Simulate_MET_data(Design=Design,K=wheat.A)

\donttest{
## Calculate the blup and the conditional variance matrix using simulated variance components
## this step can take several seconds
## note that variance can also be estimated (e.g. using BGLR)
BlupEnvBV <- EnvBV_blup(Pheno=DataSim$Pheno,K=wheat.A,Omega_G=DataSim$Omega_G,
                        Omega_E=DataSim$Omega_E)


## Compute GE metric estimates
GEmetrics_hat <- GEmetrics_blup(G_hat=BlupEnvBV$G_hat,metric="Ecovalence",P=BlupEnvBV$P)
head(GEmetrics_hat)
}
}
