% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPI_create.R
\name{get_UniqueBinFileIdentifier}
\alias{get_UniqueBinFileIdentifier}
\title{Generate Unique Bin File Identifier}
\usage{
get_UniqueBinFileIdentifier(binfile)
}
\arguments{
\item{binfile}{Text lines read from an open connection to a bin file.}
}
\value{
Single string identifier.
}
\description{
Generate Unique Bin File Identifier
}
\details{
Function to create a UniqueBinFileIdentifier from a GENEActiv bin file.
}
\examples{
binfile_path <- system.file("inst/extdata/20Hz_file.bin", package = "GENEAcore")
con <- file(binfile_path, "r")
binfile <- readLines(con, skipNul = TRUE)
close(con)
UniqueBinFileIdentifier <- get_UniqueBinFileIdentifier(binfile)
}
