% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_periods.R
\name{aggregateEpochs}
\alias{aggregateEpochs}
\title{Aggregate Epochs}
\usage{
aggregateEpochs(
  time_series,
  measure = "AGSA",
  time = "timestamp",
  sample_frequency,
  duration = NA,
  first_epoch_timestamp = NA,
  fun = mean
)
}
\arguments{
\item{time_series}{Data frame to be aggregated.}

\item{measure}{Name of the measure columns to be included.}

\item{time}{Name of the time column.}

\item{sample_frequency}{Measurement frequency of data.}

\item{duration}{Time duration to aggregate in each epoch.}

\item{first_epoch_timestamp}{Time to start the first epoch, defaults to first record.}

\item{fun}{Function to apply on aggregation, defaults to mean.}
}
\value{
Data frame of aggregated epochs.
}
\description{
Aggregate Epochs
}
\details{
Wrapper function that calls \code{aggregatePeriods} for epochs (duration of fixed length).
}
\examples{
timestamp <- c(
  1619424004, 1619424005, 1619424006, 1619424007,
  1619424008, 1619424009, 1619424010, 1619424011,
  1619424012, 1619424013, 1619424014, 1619424015
)
value <- c(
  0.729614366, 1.729115871, 0.804973546, 2.510181118,
  2.23764038, 0.613203747, 0.681953275, 0.089566943,
  0.021042388, 2.4780338, 2.437488989, 2.632635727
)
data <- data.frame(timestamp, value)
aggregated <- aggregateEpochs(data,
  duration = 5,
  measure = "value",
  sample_frequency = 1,
  first_epoch_timestamp = 1619424005,
  time = "timestamp"
)
}
