% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PubMed.search.R
\name{PubMed.search}
\alias{PubMed.search}
\title{Search prior counts for G variables and G-E interactions}
\usage{
PubMed.search(Yname, Gname, Ename, Gnamefile)
}
\arguments{
\item{Yname}{A user supplied character including disease name such as "breast".}

\item{Gname}{A user supplied character vector including all G variable names.}

\item{Ename}{A user supplied character vector including all E variable names.}

\item{Gnamefile}{A newline-delimited text file uploaded by users that contains all the G variable names to be searched. Each row represents a G variable name.
It provides another way to input G variable names besides from argument "Gname".}
}
\value{
Return the searched frequencies.
\item{G.count}{A numeric vector, presenting the prior counts for all searched G variables.}
\item{GE.count}{A numeric matrix of dimensions length(Gname) x length(Ename), which presents the prior counts
         for all G variables (Gname) and E variables (Ename) comparisons}
}
\description{
Provide an available tool for mining prior counts for G variables and G-E interactions from PubMed database.
}
\examples{
Yname <- c('breast')
Gname <- c('CAMP')
Ename <- c('Age')
res <- PubMed.search(Yname,Gname,Ename)
res
}
