% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdrisk.R
\name{gdrisk}
\alias{gdrisk}
\alias{print.gdrisk}
\alias{plot.gdrisk}
\title{Geographical detectors: risk detector.}
\usage{
gdrisk(formula, data = NULL)
\method{print}{gdrisk}(x, ...)
\method{plot}{gdrisk}(x, ...)
}
\arguments{
\item{formula}{A formula of response and explanatory variables}

\item{data}{A data.frame includes response and explanatory variables}

\item{x}{A list of risk detector results}

\item{...}{Ignore}
}
\description{
Function for risk detector calculation, risk matrix and visualization.
}
\examples{
gr1 <- gdrisk(NDVIchange ~ Climatezone + Mining, data = ndvi_40)
gr1
plot(gr1)
\donttest{
data <- ndvi_40[,1:3]
gr2 <- gdrisk(NDVIchange ~ ., data = data)
gr2
}

}
