% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StepI_chooseints.R
\name{StepI_chooseints}
\alias{StepI_chooseints}
\title{Step I: Multiple GDS runs with random interactions}
\source{
Singh, R. and Stufken, J. (2022). Factor selection in screening experiments
by aggregation over random models, 1--31. \doi{10.48550/arXiv.2205.13497}
}
\usage{
StepI_chooseints(
  delta.n = 10,
  nint,
  nrep,
  Xmain,
  Xint,
  Y,
  opt.heredity = c("none")
)
}
\arguments{
\item{delta.n}{a positive integer suggesting the number of delta values
to be tried. \code{delta.n} equally spaced values of \code{delta} will be used
strictly between 0 and \code{max(|t(X)y|)}. The default value is set to 10.}

\item{nint}{a positive integer representing the number of randomly
chosen interactions. The suggested value to use is the ceiling of 20\%
of the total number of interactions, that is, for \code{m} factors, we have
\code{ceiling(0.2(m choose 2))}.}

\item{nrep}{a positive integer representing the number of times GDS should
be run. The suggested value is \code{(m choose 2)}.}

\item{Xmain}{a \eqn{n \times m}{n x m} matrix of \code{m} main effects.}

\item{Xint}{a matrix of \eqn{{m \choose 2}}{\code{m choose 2})} two-factor
interactions.}

\item{Y}{a vector of \code{n} responses.}

\item{opt.heredity}{a string with either \code{none}, or \code{weak}, or \code{strong}. Denotes
whether the effect-heredity (weak or strong) should be embedded in GDS-ARM.
The default value is \code{none} as suggested in Singh and Stufken (2022).}
}
\value{
A list containing the (a) matrix of the output of each GDS run with each
row representing the selected effects from the corresponding GDS run, (b)
a vector with the corresponding BIC values of each model.
}
\description{
Runs the Gauss Dantzig Selector (GDS) multiple times, each time
with a different set of randomly selected two-factor interactions.
All \code{m} main effects are included in each GDS run. For each set of
randomly selected interactions, the best GDS output is chosen among
\code{delta.n} values of \code{delta}. We use kmeans with 2
clusters and BIC to select such best model.
}
\keyword{internal}
