% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmgceclassfunctions.R
\name{predict.lmgce}
\alias{predict.lmgce}
\title{Predict method for \code{\link{lmgce}} Linear Model Fits}
\usage{
\method{predict}{lmgce}(
  object,
  newdata,
  interval = c("none", "confidence"),
  type = c("response", "terms"),
  level = 0.95,
  terms = NULL,
  na.action = na.pass,
  ...
)
}
\arguments{
\item{object}{Fitted \code{\link{lmgce}} model object.}

\item{newdata}{An optional data frame in which to look for variables with
which to predict. If omitted, the fitted values are used.}

\item{interval}{One of \code{c("none", "confidence")}. Type of interval
calculation. Can be abbreviated.}

\item{type}{One of \code{c("response", "terms")}. Type of prediction
(response or model term). Can be abbreviated.}

\item{level}{Tolerance/confidence level (0,1).}

\item{terms}{if \code{type = "terms"}, which terms (default is all terms),
a \code{\link[base]{character}} vector.}

\item{na.action}{function determining what should be done with missing values
in \code{newdata}. The default is to predict \code{NA}.}

\item{...}{additional arguments.}
}
\value{
\code{predict.lmgce} produces a vector of predictions.
}
\description{
Predicted values based on a fitted model \code{\link{lmgce}} object.
}
\examples{
\donttest{
res_gce_package <-
  lmgce(y ~ .,
        data = dataGCE,
        boot.B = 50,
        seed = 230676)
}

predict(res_gce_package, dataGCE.test)

}
\author{
Jorge Cabral, \email{jorgecabral@ua.pt}
}
