% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_qtl_info.R
\name{plot_qtl_info}
\alias{plot_qtl_info}
\title{Plot QTLs information from the find_genes_qtls_around_markers output}
\usage{
plot_qtl_info(
  qtl_file,
  qtl_plot = c("qtl_type", "qtl_name"),
  n = "all",
  qtl_class = NULL,
  horiz = FALSE,
  ...
)
}
\arguments{
\item{qtl_file}{The output from find_genes_qtls_around_markers function}

\item{qtl_plot}{"qtl_type" or"qtl_name"}

\item{n}{Number of QTLs to be plotted when the qtl_name option is selected}

\item{qtl_class}{Class of QTLs to be plotted when the qtl_name option is selected}

\item{horiz}{The legend of the pie plot for the qtl_type should be plotted vertically or horizontally. The default is FALSE. Therefore, the legend is plotted vertically.}

\item{...}{Arguments to be passed to/from other methods. For the default method these can include further arguments (such as axes, asp and main) and graphical parameters (see par) which are passed to plot.window(), title() and axis.}
}
\value{
A plot with the requested information
}
\description{
Takes the output from find_genes_qtls_around_markers and create plots for the frequency of each QTL type and trait
}
\examples{
data(QTLmarkers)
data(gffQTLs)

out.qtls<-find_genes_qtls_around_markers(db_file=gffQTLs,
marker_file=QTLmarkers, method = "qtl",
marker = "snp", interval = 500000,
nThreads = 1)

plot_qtl_info(out.qtls, qtl_plot = "qtl_type", cex=2)
}
