% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simData1.R
\name{simData1}
\alias{simData1}
\title{Generate simulated data for \code{\link{SNPlm}}}
\usage{
simData1(n, m, seed)
}
\arguments{
\item{n}{an interger variable specifying the number of samples to be generated.}

\item{m}{an interger variable specifying the sequence length of each sample.}

\item{seed}{an integer variable specifying the random seed used for random sequence generation.}
}
\value{
An "simData1" object that contains the list of the following items.
\itemize{
\item{y:}{ a numeric vector representing the response variables.}
\item{z:}{ a matrix representing the scalar covariates, with the number of rows equal to the number of samples.}
\item{location:}{ a numeric vector defining the sampling sites of the sequence (genotypes) data.}
\item{X:}{ a matrix representing the sequence data, with the number of rows equal to the number of samples.}
\item{beta:}{ an "fd" object, representing the genetic effect function.}
}
}
\description{
Generate simulated data for users to apply the method SNPlm, including response variable y, scalar variable Z and sequence (genotypes) data X.
}
\examples{
library(FunctanSNP)
n <- 300
m <- 30
simdata1 <- simData1(n, m, seed = 123)

}
\seealso{
See Also as \code{\link{simX}}, \code{\link{SNPlm}}.
}
