% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGVF.R
\name{plotGVF}
\alias{plotGVF}
\title{Plot the genetic variant function}
\usage{
plotGVF(x, y = NULL, Lfdobj = 0, href = TRUE, titles = NULL,
  xlim = NULL, ylim = NULL, xlab = NULL, ylab = NULL,
  ask = FALSE, nx = NULL, axes = NULL)
}
\arguments{
\item{x}{functional data object(s) to be plotted, such as the estimated genetic variant function obtained by SNPgvf.}

\item{y}{sequence of points at which to evaluate the functions 'x' and plot on the horizontal axis. Defaults to seq(rangex[1], rangex[2], length = nx).}

\item{Lfdobj}{either a nonnegative integer or a linear differential operator object. If present, the derivative or the value of applying the operator is plotted rather than the functions themselves.}

\item{href}{a logical variable: If TRUE, add a horizontal reference line at 0.}

\item{titles}{a vector of strings for identifying curves}

\item{xlim}{a vector of length 2 containing axis limits for the horizontal axis.}

\item{ylim}{a vector of length 2 containing axis limits for the vertical axis.}

\item{xlab}{a label for the horizontal axis.}

\item{ylab}{a label for the vertical axis.}

\item{ask}{a logical value: If TRUE, each curve is shown separately, and the plot advances with a mouse click}

\item{nx}{the number of points to use to define the plot. The default is usually enough, but for a highly variable function more may be required.}

\item{axes}{Either a logical or a list or NULL.
\itemize{
\item{logical}{ whether axes should be drawn on the plot}
\item{list}{ a list used to create custom axes used to create axes via x$axes[[1]] and x$axes[-1]. The primary example of this uses list("axesIntervals", ...)}
}}
}
\value{
plot the estimated genetic variant function.
}
\description{
Plot the estimated genetic variant function obtained by SNPgvf or a given functional data object(s).
}
\examples{
library(FunctanSNP)
n <- 20
m <- 50
simdata <- simX(n, m, seed = 1, d.ratio = 0)
X <- simdata$X
location <- simdata$location
SNPgvfres <- SNPgvf(location, X, type = "Bspline", nbasis = 5, params = 4, Plot = FALSE)
plotGVF(SNPgvfres)

}
\seealso{
See Also as \code{\link{SNPgvf}}.
}
