% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_ccircle_spatial.R
\name{new_fe_ccircle_spatial}
\alias{new_fe_ccircle_spatial}
\title{Constructor for the \strong{fe_ccircle_spatial} Class}
\usage{
new_fe_ccircle_spatial(x = list(), ..., class = character())
}
\arguments{
\item{x}{An appropriate \code{list} object}

\item{...}{Additional arguments required for enabling subclasses of
\code{fe_ccircle_spatial}}

\item{class}{A Character string required for enabling subclasses of
\code{fe_ccircle_spatial}}
}
\value{
An object of class \code{fe_ccircle_spatial}
}
\description{
Should be used by expert users only who know exactly what they are doing.
Other users please take the function \code{\link{fe_stand}} for creating an
object of that class.
}
\examples{

#' # Constructing a minimal fe_ccircle_spatial object from scratch
# Use fe_ccircle_spatial() if you are not absolutely sure

trees <- data.frame(
  tree_id = as.character(c(1:10)),
  species_id = as_fe_species_tum_wwk_short(rep("5", 10)),
  layer_key = 1,
  time_yr = 2024,
  dbh_cm = rnorm(10, 50, 8),
  age_yr = NA_real_,
  height_m = NA_real_,
  crown_base_height_m = NA_real_,
  crown_radius_m = NA_real_,
  removal = FALSE,
  ingrowth = FALSE,
  n_rep_ha = 1 / 0.75
)

# define a circle definition with three concentric circles
circle_def <- data.frame(
  dbh_lower = c(0,12,30),
  dbh_upper = c(11.9,29.9,999.0),
  c_area = c(0.0025, 0.0060, 0.0500)
)

# generate tree positions in polar coordinates for the 10 trees

tree_positions <- data.frame(
 tree_id = as.character(c(1:10)),
 R = runif(10, 1, 12),
 angle = runif(10, 0, 360)) |>
 dplyr::mutate(
 #convert the polar coordinates to cartesian and into an sf object
 x_pos = R*sin(angle*pi / 180),
 y_pos = R*cos(angle*pi / 180)
 ) |> sf::st_as_sf(coords = c("x_pos", "y_pos"))

# generate a NA dummy for small_trees

  small_trees <- data.frame(
  tree_id = NA_character_,
  species_id = NA_character_,
  layer_key = NA_real_,
  time_yr = NA_real_,
  dbh_cm = NA_real_,
  age_yr = NA_real_,
  height_m = NA_real_
  )

fe_ccircle_spatial_candidate <- list(
  stand_id = "my_interesting_stand",
  small_trees = small_trees,
  trees = trees,
  circle_definition = circle_def,
  tree_positions = tree_positions,
  time_yr = 2024
)

fe_ccircle_object <- new_fe_ccircle_spatial(fe_ccircle_spatial_candidate)

# Better validate it
fe_ccircle_object |> validate_fe_ccircle_spatial()


}
