
#' Civilian Unemployment Rate (UNEMP)
#'
#' Error Statistics for the Survey of Professional Forecasters for Unemployment Rate. All NAs are replaced with 0 as in Coroneo and Iacone (2020).
#'
#' @format `UNEMP`
#' A data frame with 219 rows and 16 columns
#' @references Coroneo, L., Iacone, F. (2020), Comparing Predictive Accuracy in Small Samples Using Fixed-Smoothing Asymptotics, \emph{Journal of Applied Econometrics}, \bold{35}(4), 391-409.
#' @source <https://www.philadelphiafed.org/-/media/frbp/assets/surveys-and-data/survey-of-professional-forecasters/data-files/unemp/data_spf_error_statistics_unemp_1_aic.xls?la=en&hash=4CAD0B11FEAB6C4D0F30C38965FE3354>
"UNEMP"


#' 3-Month Treasury Bill Rate (TBILL)
#'
#' Error Statistics for the Survey of Professional Forecasters for Treasury Bill Rate (Three Month). All NAs are replaced with 0 as in Coroneo and Iacone (2020).
#'
#' @format `TBILL`
#' A data frame with 219 rows and 16 columns
#' @references Coroneo, L., Iacone, F. (2020), Comparing Predictive Accuracy in Small Samples Using Fixed-Smoothing Asymptotics, \emph{Journal of Applied Econometrics}, \bold{35}(4), 391-409.
#' @source <https://www.philadelphiafed.org/-/media/frbp/assets/surveys-and-data/survey-of-professional-forecasters/data-files/tbill/data_spf_error_statistics_tbill_1_aic.xls?la=en&hash=F432350F84B0E4CCE9A1E9D399447CA9>
"TBILL"


#' Real Gross National Product/Gross Domestic Product (RGDP)
#'
#' Error Statistics for the Survey of Professional Forecasters for Real GNP/GDP. All NAs are replaced with 0 as in Coroneo and Iacone (2020).
#'
#' @format `RDGP`
#' A data frame with 219 rows and 16 columns
#' @references Coroneo, L., Iacone, F. (2020), Comparing Predictive Accuracy in Small Samples Using Fixed-Smoothing Asymptotics, \emph{Journal of Applied Econometrics}, \bold{35}(4), 391-409.
#' @source <https://www.philadelphiafed.org/-/media/frbp/assets/surveys-and-data/survey-of-professional-forecasters/data-files/rgdp/data_spf_error_statistics_rgdp_3_aic.xls?la=en&hash=3AC9E2D8A5299F93CA7E16CFAA974C22>
"RGDP"


#' Price Index for Gross National Product/Gross Domestic Product (PGDP)
#'
#' Error Statistics for the Survey of Professional Forecasters for GNP/GDP Price Index. All NAs are replaced with 0 as in Coroneo and Iacone (2020).
#'
#' @format `PGDP`
#' A data frame with 219 rows and 16 columns
#' @references Coroneo, L., Iacone, F. (2020), Comparing Predictive Accuracy in Small Samples Using Fixed-Smoothing Asymptotics, \emph{Journal of Applied Econometrics}, \bold{35}(4), 391-409.
#' @source <https://www.philadelphiafed.org/-/media/frbp/assets/surveys-and-data/survey-of-professional-forecasters/data-files/pgdp/data_spf_error_statistics_pgdp_3_aic.xls?la=en&hash=148987D03D54DA5391A44F28CBC12729>
"PGDP"

