% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvspectrum-utils.R
\name{mvspectrum-utils}
\alias{mvspectrum-utils}
\alias{plot.mvspectrum}
\title{S3 methods for class 'mvspectrum'}
\usage{
\method{plot}{mvspectrum}(x, log = TRUE, ...)
}
\arguments{
\item{x}{an object of class \code{"foreca.one_weightvector"}.}

\item{log}{logical; if \code{TRUE} (default), it plots the spectra on 
log-scale.}

\item{...}{additional arguments passed to \code{\link[graphics]{matplot}}.}
}
\description{
S3 methods for multivariate spectrum estimation.

\code{plot.mvspectrum} plots all univariate spectra. Analogouos to 
\code{\link[stats]{spectrum}} when \code{plot = TRUE}.
}
\examples{
# see examples in 'mvspectrum'

SS <- mvspectrum(diff(log(EuStockMarkets)) * 100, 
                 spectrum.control = list(method = "mvspec"))
plot(SS, log = FALSE)

}
\seealso{
\code{\link{get_spectrum_from_mvspectrum}}
}
\keyword{hplot}
\keyword{manip}
