% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FoRDM.R
\name{build_objectives_regret}
\alias{build_objectives_regret}
\title{Build Objectives Data Frame for Regret Analysis}
\usage{
build_objectives_regret(
  names,
  direction = rep("maximize", length(names)),
  weights = rep(1/length(names), length(names)),
  time_aggregation = rep("mean", length(names)),
  discount_rate = rep(0, length(names))
)
}
\arguments{
\item{names}{Names of objectives as the column names in the provided data.}

\item{direction}{Direction of objective function: 'maximize' or 'minimize'.}

\item{weights}{Relative weights (0-1) for each objective, must sum to 1.}

\item{time_aggregation}{Time aggregation across objectives: 'mean', 'sum', 'min' or 'max'.}

\item{discount_rate}{Annual discount rates for each objective (e.g., 0.02 means 2\% per year), applied during time aggregation.}
}
\value{
A data frame specifying objectives, directions, weights, time aggregation methods, and discount rates for use in FoRDM analysis.
}
\description{
Specify for which objectives regret-based FoRDM analysis should be applied. For each objective, define its name, direction, weight, time aggregation method (mean, sum, min or max), and discount rate.
}
