% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screen.series.R
\name{screen.series}
\alias{screen.series}
\title{Create a plot of the daily streamflow time series}
\usage{
screen.series(TS, title = FALSE, change.margins = TRUE)
}
\arguments{
\item{TS}{data.frame of streamflow time series loaded with \code{\link{read.flows}}.}

\item{title}{optional plot title. Default is FALSE indicating no plot title is wanted. 
Set to TRUE to use the the default plot title, which will 
look for 'plot title' attribute of the data.frame set by 
\code{\link{set.plot.titles}}. All values other values 
will be used as a custom plot title.}

\item{change.margins}{TRUE or FALSE to indicate whether the user's current 
margin settings should be used, or if the margins should be set within the 
function. Default is TRUE, to set margins to the minimal amount.}
}
\description{
Plots the daily streamflow time series and color codes points by data quality codes if 
the data are from Water Survey Canada. Also highlights date ranges with missing
observations.
}
\examples{
# load flow time series for the Caniapiscau River
data(cania.sub.ts)

# plot daily time series with default margin text
screen.series(cania.sub.ts)
}
\author{
Jennifer Dierauer and Paul Whitfield
}
