% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_diagonal_arrangement.R
\name{diagonal_arrangement}
\alias{diagonal_arrangement}
\title{Spatial Un-replicated Diagonal Arrangement Design}
\usage{
diagonal_arrangement(
  nrows = NULL,
  ncols = NULL,
  lines = NULL,
  checks = NULL,
  planter = "serpentine",
  l = 1,
  plotNumber = 101,
  kindExpt = "SUDC",
  splitBy = "row",
  seed = NULL,
  blocks = NULL,
  exptName = NULL,
  locationNames = NULL,
  multiLocationData = FALSE,
  data = NULL
)
}
\arguments{
\item{nrows}{Number of rows in the field.}

\item{ncols}{Number of columns in the field.}

\item{lines}{Number of genotypes, experimental lines or treatments.}

\item{checks}{Number of genotypes checks.}

\item{planter}{Option for \code{serpentine} or \code{cartesian} plot arrangement. 
By default  \code{planter = 'serpentine'}.}

\item{l}{Number of locations or sites. By default  \code{l = 1}.}

\item{plotNumber}{Numeric vector with the starting plot number for each location. 
By default \code{plotNumber = 101}.}

\item{kindExpt}{Type of diagonal design, with single options: Single Un-replicated Diagonal Checks
\code{'SUDC'} and Decision Blocks Un-replicated Design with Diagonal Checks \code{'DBUDC'} 
for multiple experiments. By default \code{kindExpt = 'SUDC'}.}

\item{splitBy}{Option to split the field when \code{kindExpt = 'DBUDC'} is selected. 
By default \code{splitBy = 'row'}.}

\item{seed}{(optional) Real number that specifies the starting seed to obtain reproducible designs.}

\item{blocks}{Number of experiments or blocks to generate an \code{DBUDC} design. 
If \code{kindExpt = 'DBUDC'} and data is null, \code{blocks} are mandatory.}

\item{exptName}{(optional) Name of the experiment.}

\item{locationNames}{(optional) Names each location.}

\item{multiLocationData}{(optional) Option to pass an entry list for multiple locations. 
By default \code{multiLocationData = FALSE}.}

\item{data}{(optional) Data frame with 2 columns: \code{ENTRY | NAME }.}
}
\value{
A list with five elements.
\itemize{
  \item \code{infoDesign} is a list with information on the design parameters.
  \item \code{layoutRandom} is a matrix with the randomization layout.
  \item \code{plotsNumber} is a matrix with the layout plot number.
  \item \code{data_entry} is a data frame with the data input.
  \item \code{fieldBook} is a data frame with field book design. This includes the index (Row, Column).
}
}
\description{
Randomly generates an spatial un-replicated diagonal arrangement design.
}
\examples{

# Example 1: Generates a spatial single diagonal arrangement design in one location
# with 270 treatments and 30 check plots for a field with dimensions 15 rows x 20 cols
# in a serpentine arrangement.
spatd <- diagonal_arrangement(
  nrows = 15, 
  ncols = 20, 
  lines = 270, 
  checks = 4, 
  plotNumber = 101, 
  kindExpt = "SUDC", 
  planter = "serpentine", 
  seed = 1987,
  exptName = "20WRY1", 
  locationNames = "MINOT"
)
spatd$infoDesign
spatd$layoutRandom
spatd$plotsNumber
head(spatd$fieldBook, 12)

# Example 2: Generates a spatial decision block diagonal arrangement design in one location
# with 720 treatments allocated in 5 experiments or blocks for a field with dimensions
# 30 rows x 26 cols in a serpentine arrangement. In this case, we show how to set up the data 
# option with the entries list.
checks <- 5;expts <- 5
list_checks <- paste("CH", 1:checks, sep = "")
treatments <- paste("G", 6:725, sep = "")
treatment_list <- data.frame(list(ENTRY = 1:725, NAME = c(list_checks, treatments)))
head(treatment_list, 12) 
tail(treatment_list, 12)
spatDB <- diagonal_arrangement(
  nrows = 30, 
  ncols = 26,
  checks = 5, 
  plotNumber = 1, 
  kindExpt = "DBUDC", 
  planter = "serpentine", 
  splitBy = "row", 
  blocks = c(150,155,95,200,120),
  data = treatment_list
)
spatDB$infoDesign
spatDB$layoutRandom
spatDB$plotsNumber
head(spatDB$fieldBook,12)

# Example 3: Generates a spatial decision block diagonal arrangement design in one location
# with 270 treatments allocated in 3 experiments or blocks for a field with dimensions
# 20 rows x 15 cols in a serpentine arrangement. Which in turn is an augmented block (3 blocks).
spatAB <- diagonal_arrangement(
  nrows = 20, 
  ncols = 15, 
  lines = 270, 
  checks = 4, 
  plotNumber = c(1,1001,2001), 
  kindExpt = "DBUDC", 
  planter = "serpentine",
  exptName = c("20WRA", "20WRB", "20WRC"), 
  blocks = c(90, 90, 90),
  splitBy = "column"
)
spatAB$infoDesign
spatAB$layoutRandom
spatAB$plotsNumber
head(spatAB$fieldBook,12)

}
\references{
Clarke, G. P. Y., & Stefanova, K. T. (2011). Optimal design for early-generation plant
breeding trials with unreplicated or partially replicated test lines. Australian & New
Zealand Journal of Statistics, 53(4), 461–480.
}
\author{
Didier Murillo [aut],
        Salvador Gezan [aut],
        Ana Heilman [ctb],
        Thomas Walk [ctb], 
        Johan Aparicio [ctb], 
        Richard Horsley [ctb]
}
