% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_logishp.R
\name{logit}
\alias{logit}
\alias{invlogit}
\title{Logit and Invlogit Functions}
\usage{
logit(p)

invlogit(x)
}
\arguments{
\item{p}{numeric. one value or a vector between 0 and 1.}

\item{x}{numeric. one value or a vector of numerics.}
}
\description{
The logit and invlogit functions, widely used in this package, are wrappers  
of \code{\link{qlogis}} and \code{\link{plogis}} functions.
}
\details{
\code{logit} function is defined for p in (0, 1) by: 
              \deqn{ logit(p) = log( p/(1-p) ) }

              \code{invlogit} function is defined for x in (-Inf, +Inf) by: 
              \deqn{ invlogit(x) = exp(x)/(1+exp(x)) = plogis(x) }
}
\examples{
    
logit( c(ppoints(11, a = 1), NA, NaN) )
invlogit( c(-Inf, -10:10, +Inf, NA, NaN) )

}
