% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrainFastImputation.R
\name{TrainFastImputation}
\alias{TrainFastImputation}
\title{Learn from the training data so that later you can fill in missing data}
\usage{
TrainFastImputation(x, constraints = list(), idvars, categorical)
}
\arguments{
\item{x}{Dataframe containing training data. Can have incomplete rows.}

\item{constraints}{A list of constraints.  See the examples below for formatting details.}

\item{idvars}{A vector of column numbers or column names to be ignored in the imputation process.}

\item{categorical}{A vector of column numbers or column names of varaibles with a (small) set of possible values.}
}
\value{
An object of class 'FastImputationPatterns' that contains
  information needed later to impute on a single row.
}
\description{
Like Amelia, FastImputation assumes that the columns of the data are
multivariate normal or can be transformed into approximately
multivariate normal.
}
\examples{

data(FI_train)   # provides FI_train dataset

patterns_with_constraints <- TrainFastImputation(
  FI_train,
  constraints=list(list("bounded_below_2", list(lower=0)),
                   list("bounded_above_5", list(upper=0)),
                   list("bounded_above_and_below_6", list(lower=0, upper=1))
                   ),
  idvars="user_id_1",
  categorical="categorical_9")
  
}
\references{
\url{https://gking.harvard.edu/amelia}
}
\seealso{
\code{\link{FastImputation}}
}
\author{
Stephen R. Haptonstahl \email{srh@haptonstahl.org}
}
